% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_scdf.R
\name{read_scdf}
\alias{read_scdf}
\alias{readSC.excel}
\alias{readSC}
\title{Load single-case data from files}
\usage{
read_scdf(
  filename,
  data = NULL,
  sort.labels = FALSE,
  cvar = "case",
  pvar = "phase",
  dvar = "values",
  mvar = "mt",
  phase.names = NULL,
  sep = ",",
  dec = ".",
  type = NA,
  ...
)

readSC.excel(...)

readSC(...)
}
\arguments{
\item{filename}{A character string defining the file to be loaded (e.g.
\code{"SC_Anita.csv"}. If left empty a dialog box for choosing will be
opened.}

\item{data}{A data frame. As an alternative to \code{filname}.}

\item{sort.labels}{If set TRUE, the resulting list is sorted by label names
(alphabetically increasing).}

\item{cvar}{Sets the variable name of the "case" variable. Defaults to
\code{"case"}.}

\item{pvar}{Sets the variable name of the "phase" variable. Defaults to
\code{"phase"}.}

\item{dvar}{Sets the variable name of the "values" variable. Defaults to
\code{"values"}.}

\item{mvar}{Sets the variable name of the "mt" variable. Defaults to
\code{"mt"}.}

\item{phase.names}{A character vector with phase names. Defaults to the phase
names provided in the phase variable.}

\item{sep}{The field separator string. Values within each row of x are 
separated by this string.}

\item{dec}{The string to use for decimal points in numeric or complex 
columns: must be a single character.}

\item{type}{Format of the file to be loaded. Either "csv", "xlsx", "xls",
"excel", "yml" is possible. By default (NA) the type is extracted from the
file extension.}

\item{\dots}{Further arguments passed to the repective read function
(\code{\link{read.table}}, \code{\link{read_excel}},
\code{\link{read_yaml}} command.}
}
\value{
Returns a single-case data frame. See \code{\link{scdf}} to learn
  about the format of these data frames.
}
\description{
Use the \code{read_scdf} function to load single-case data csv, excel, or
yaml files.
}
\examples{

## Read SC-data from a file named "study1.csv" in your working directory
# study1 <- read_scdf("study1.csv")

## Read SC-data from a .csv-file with semicolon as field and comma as decimal separator
# study2 <- read_scdf("study2.csv", sep = ";", dec = ",")

## write_scdf and read_scdf
filename <- file.path(tempdir(), "test.csv")
write_scdf(exampleA1B1A2B2_zvt, filename)
dat <- read_scdf(filename, cvar = "case", pvar = "part", dvar = "zvt", mvar = "day")
res1 <- describe(exampleA1B1A2B2_zvt)$descriptives
res2 <- describe(dat)$descriptives
all.equal(res1,res2)

}
\seealso{
\code{\link{read.table}}, \code{\link{writeSC}}, \code{\link{scdf}},
  \code{\link{readRDS}}
}
\author{
Juergen Wilbert
}
\keyword{manip}
