% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranks.R
\name{ranks}
\alias{ranks}
\title{Rank-transformation of single-case data files}
\usage{
ranks(data, var, grand = TRUE, ...)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{var}{A string or string vector with the names of the variables to be ranked.}

\item{grand}{If TRUE, ranks will be calculated across all cases. If FALSE ranks are calculated within each case.}

\item{...}{Additional paramters passed to the \code{\link{rank}} function.}
}
\value{
An \code{scdf} object where the values of the variable(s) are replaced with ranks.
}
\description{
Rank-transformation of single-case data files
}
\examples{
Huber2014_rank <- ranks(Huber2014, var = "compliance")
plot(Huber2014_rank, style = "grid2")
}
\seealso{
Other data manipulation functions: 
\code{\link{as.data.frame.scdf}()},
\code{\link{fill_missing}()},
\code{\link{outlier}()},
\code{\link{shift}()},
\code{\link{smooth_cases}()},
\code{\link{standardize}()},
\code{\link{truncate_phase}()}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
