% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_power.testSC.R
\name{power.testSC}
\alias{power.testSC}
\title{(Deprecated function) Empirical power analysis for single-case data}
\usage{
power.testSC(
  data = NULL,
  dvar,
  pvar,
  mvar,
  parameters = NULL,
  stat = c("rand.test", "plm"),
  test.parameter = c("level", "slope"),
  rand.test.stat = c("Mean B-A", "B"),
  cases = NULL,
  rtt = NULL,
  level = NULL,
  slope = NULL,
  MT = NULL,
  B.start = NULL,
  trend = NULL,
  n_sim = 100,
  limit = 5,
  m = NULL,
  s = NULL,
  startpoints = NA,
  extreme.p = 0,
  extreme.d = c(-4, -3),
  exclude.equal = "auto",
  alpha = 0.05,
  distribution = "normal",
  silent = TRUE
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable. Defaults to the attributes in the scdf file.}

\item{parameters}{-}

\item{stat}{Defines the tests the power analysis is computed for. The
default \code{stat = c("rand.test","plm")} computes a power analysis for the
\code{\link{randSC}} and the \code{\link{plm}} analyses. Further
possibilities are \code{"hplm"} for a hierarchiacal linear regression model
and \code{"plm.poisson"} for a generalized piecewise-regression model under
the assumption of poisson distributed errors.}

\item{test.parameter}{Indicates whether the power and alpha error for a
level effect, a slope effect, or both effects should be estimated. The
default setting \code{test.parameter = c("level", "slope")} requests both.}

\item{rand.test.stat}{Defines the statistic the randomization test is based
on. The first values stipulates the statistic for the level-effect
computation and the second value for the slope-effect computation. Default
is \code{rand.test.stat = c("Mean B-A","B")}. Please see
\code{\link{randSC}} for more information on the test statistics.}

\item{cases}{Number of cases per study.}

\item{rtt}{Reliability of the underlying simulated measurements. Default is
\code{rtt = 0.8}.}

\item{level}{Defines the level increase (effect size \emph{d}) at the
beginning of phase B.}

\item{slope}{Defines the increase in scores - starting with phase B -
expressed as effect size \emph{d} per MT. \code{slope = .1} generates an
incremental increase of 0.1 standard deviations per MT for all phase B
measurements.}

\item{MT}{Number of measurements (in each study).}

\item{B.start}{Phase B starting point. A single value (e.g., \code{B.start =
6}) defines \code{B.start} for all studies and cases. A vector of starting
values is given with the chain command (e.g., \code{B.start = c(6, 7, 8)}).
A value between 0 and 1 is interpreted as a proportion (e.g., \code{B.start
= c(0.3, 0.5, 0.8)} would start phase B at 30, 50, and 80\% of the MTs).}

\item{trend}{Defines the effect size \emph{d} of a trend per MT added
across the whole data-set.}

\item{n_sim}{Number of sample studies created for the the Monte-Carlo study.
Default is \code{n = 100}}

\item{limit}{Minimal number of data points per phase in the sample. Default
is \code{limit = 5}.}

\item{m}{Mean of the sample distribution the data are drawn from.}

\item{s}{Standard deviation of the sample distribution the data are drawn
from.}

\item{startpoints}{Alternative to the \code{limit} parameter start points
exactly defines the possible start points of phase B (e.g.,
\code{startpoints = 4:9} restricts the phase B start points to measurements
4 to 9. \code{startpoints} overruns the \code{limit} parameter.}

\item{extreme.p}{Probability of extreme values. \code{extreme.p = .05} gives
a five percent probability of an extreme value. Default is \code{extreme.p =
0}.}

\item{extreme.d}{Range for extreme values, expressed as effect size
\emph{d}. \code{extreme.d = c(-7,-6)} uses extreme values within a range of
-7 and -6 standard deviations. Caution: the first value must be smaller than
the second, otherwise the procedure will fail. Default is \code{extreme.d =
c(-4,-3)}.}

\item{exclude.equal}{If set to \code{exclude.equal = FALSE}, random
distribution values equal to the observed distribution are counted as
null-hypothesis conform. That is, they decrease the probability of rejecting
the null-hypothesis (increase the p-value). Default is \code{exclude.equal =
"auto"}, which means \code{FALSE} for multiple baseline designs and
\code{TRUE} for one single-case.}

\item{alpha}{Alpha level used to calculate the proportion of significant
tests. Default is \code{alpha = 0.05}.}

\item{distribution}{Indicates whether the random sample is based on a
\code{"normal"} or a \code{"poisson"} distribution. Default is
\code{distribution = "normal"}.}

\item{silent}{If set \code{TRUE}, the results are not printed after
computation. Default is \code{silent = FALSE}.}
}
\description{
!! This function is deprecated. Please use the power_testSC fucntion !!
The \code{power.testSC} command conducts a Monte-Carlo study on the
test-power and alpha-error of a randomization-test and a
piecewise-regression model.  The distribution values of the Monte-Carlo
sample are either specified by the user or estimated based on actual data.
}
\examples{

## Assume you want to conduct a single-case study with 15 MTs, using a highly reliable test,
## an expected level effect of \eqn{d = 1.4}, and randomized start points between MTs 5
## and 12 can you expect to identify the effect using plm or randomization test?
mc_par <- list(
  n_cases = 1, mt = 15, B.start = round(runif (300,5,12)), 
  rtt = 0.8, level = 1.4
)
res <- power.testSC(
  parameters = mc_par, 
  stat = c("rand.test","hplm"), 
  test.parameter = "level",
  startpoints = 5:12,
  n_sim = 100
)
## Would you achieve higher power by setting up a MBD with three cases?
mc_par <- list(
  n_cases = 3, mt = 15, B.start = round(runif (300,5,12)), 
  rtt = 0.8, level = 1.4
)
power.testSC(
  parameters = mc_par, 
  stat = c("rand.test","hplm"), 
  test.parameter = "level", 
  startpoints = 5:12,
  n_sim = 10
)

}
\seealso{
\code{\link{plm}}, \code{\link{randSC}}
}
\author{
Juergen Wilbert
}
