% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scR.R
\name{simvcd}
\alias{simvcd}
\title{Estimate the Vapnik-Chervonenkis (VC) dimension of an arbitrary binary classification algorithm.}
\usage{
simvcd(
  model,
  dim,
  packages = list(),
  m = 1000,
  k = 1000,
  maxn = 5000,
  parallel = TRUE,
  coreoffset = 0,
  predictfn = NULL,
  a = 0.16,
  a1 = 1.2,
  a11 = 0.14927,
  ...
)
}
\arguments{
\item{model}{A binary classification model supplied by the user. Must take arguments \code{formula} and \code{data}}

\item{dim}{A positive integer giving dimension (number of input features) of the model.}

\item{packages}{A \code{list} of strings giving the names of packages to be loaded in order to estimate the model.}

\item{m}{A positive integer giving the number of simulations to be performed at each design point (sample size value). Higher values give more accurate results but increase computation time.}

\item{k}{A positive integer giving the number of design points (sample size values) for which the bounding function is to be estimated. Higher values give more accurate results but increase computation time.}

\item{maxn}{Gives the vertical dimension of the data (number of observations) to be generated.}

\item{parallel}{Boolean indicating whether or not to use parallel processing.}

\item{coreoffset}{If \code{parallel} is true, a positive integer indicating the number of free threads to be kept unused. Should not be larger than the number of CPU cores.}

\item{predictfn}{An optional user-defined function giving a custom predict method. If also using a user-defined model, the \code{model} should output an object of class \code{"svrclass"} to avoid errors.}

\item{a}{Scaling coefficient for the bounding function. Defaults to the value given by Vapnik, Levin and Le Cun 1994.}

\item{a1}{Scaling coefficient for the bounding function. Defaults to the value given by Vapnik, Levin and Le Cun 1994.}

\item{a11}{Scaling coefficient for the bounding function. Defaults to the value given by Vapnik, Levin and Le Cun 1994.}

\item{...}{Additional arguments that need to be passed to \code{model}}
}
\value{
A real number giving the estimated value of the VC dimension of the supplied model.
}
\description{
Estimate the Vapnik-Chervonenkis (VC) dimension of an arbitrary binary classification algorithm.
}
\examples{
mylogit <- function(formula, data){
m <- structure(
  glm(formula=formula,data=data,family=binomial(link="logit")),
  class=c("svrclass","glm")  #IMPORTANT - must use the class svrclass to work correctly
)
return(m)
}
mypred <- function(m,newdata){
out <- predict.glm(m,newdata,type="response")
out <- factor(ifelse(out>0.5,1,0),levels=c("0","1"))
#Important - must specify levels to account for possibility of all
#observations being classified into the same class in smaller samples
return(out)
}
library(parallel)
vcd <- simvcd(model=mylogit,dim=7,m=10,k=10,maxn=50,predictfn = mypred,
    coreoffset = (detectCores() -2))
}
\seealso{
\code{\link[=scb]{scb()}}, to calculate sample complexity bounds given estimated VCD.
}
