% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/human_mouse_ct_marker_enrich.R
\name{human_mouse_ct_marker_enrich}
\alias{human_mouse_ct_marker_enrich}
\title{Consensus cell-type naming (Fisher's Exact)}
\usage{
human_mouse_ct_marker_enrich(
  gene_lists,
  theSpecies = "human",
  cell_marker_path = "",
  naming_preference = -9
)
}
\arguments{
\item{gene_lists}{A named list of vectors containing cell-type markers (mouse or human gene-symbols) which will be named as a cell-type via the Fisher's exact test method.}

\item{theSpecies}{The species of the gene symbols: "human" or "mouse".}

\item{cell_marker_path}{If local, path to cell-type marker rda files, otherwise, we will try to download data files.}

\item{naming_preference}{Either -9 if there is no expected cell-type or one of the categories from get_naming_preference_options(). This is useful if you previously have an idea of which cell-type you were going to enrich.}
}
\value{
List with the following elements:
\item{cellTypes}{most likely marker for each cell-type from each database.}
\item{marker_sets}{all enriched cell-types for each cluster from each dataset.}
}
\description{
This function completes the Fisher's exact test cell-type naming for all cell-types.
}
\details{
Fisher's exact test method of cell-type identification using the Panglao and CellMarker databases. It extracts significant pathways (pFDR < 0.05).
Then, if naming_preference != -9, it will extract the enriched cell-types within the cell-types identified with the naming preferences option.
Generally, this method seems to be biased to cell-types with a greater number of markers.
}
\examples{
\donttest{

data(POA_example)
POA_generes <- POA_example$POA_generes
POA_OR_signature <- POA_example$POA_OR_signature
POA_Rank_signature <- POA_example$POA_Rank_signature
Signature <- POA_Rank_signature
rowname <- get_gene_symbol(Signature)
rownames(Signature) <- rowname$rowname
genes <- rownames(Signature)[1:100]
enriched <- human_mouse_ct_marker_enrich(gene_lists = genes, theSpecies = "mouse", 
                                         cell_marker_path = "", naming_preference = "brain")
 }
}
