% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_LR_interact.R
\name{prep_LR_interact}
\alias{prep_LR_interact}
\title{Prepare data for LR analysis and get soft thresholds to use for gene modules}
\usage{
prep_LR_interact(
  container,
  lr_pairs,
  norm_method = "trim",
  scale_factor = 10000,
  var_scale_power = 0.5,
  batch_var = NULL
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{lr_pairs}{data.frame Data of ligand-receptor pairs. First column should
be ligands and second column should be one or more receptors separated by an
underscore such as receptor1_receptor2 in the case that multiple receptors are
required for signaling.}

\item{norm_method}{character The normalization method to use on the pseudobulked
count data. Set to 'regular' to do standard normalization of dividing by
library size. Set to 'trim' to use edgeR trim-mean normalization, whereby counts
are divided by library size times a normalization factor. (default='trim')}

\item{scale_factor}{numeric The number that gets multiplied by fractional counts
during normalization of the pseudobulked data (default=10000)}

\item{var_scale_power}{numeric Exponent of normalized variance that is
used for variance scaling. Variance for each gene
is initially set to unit variance across donors (for a given cell type).
Variance for each gene is then scaled by multiplying the unit scaled values
by each gene's normalized variance (where the effect of the mean-variance
dependence is taken into account) to the exponent specified here.
If NULL, uses var_scale_power from container$experiment_params. (default=.5)}

\item{batch_var}{character A batch variable from metadata to remove (default=NULL)}
}
\value{
The project container with added container$scale_pb_extra slot that contains
the tensor with additional ligands and receptors. Also has container$no_scale_pb_extra
slot with pseudobulked, normalized data that is not scaled.
}
\description{
Prepare data for LR analysis and get soft thresholds to use for gene modules
}
