% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plot_UCell_scores}
\alias{plot_UCell_scores}
\title{Plot UCell scores by level}
\usage{
plot_UCell_scores(
  obj,
  model,
  overlay = 5,
  pos.thr = 0.2,
  neg.thr = 0.2,
  ncol = NULL,
  combine = TRUE
)
}
\arguments{
\item{obj}{Gated Seurat object (output of scGate)}

\item{model}{scGate model used to identify a target population in obj}

\item{overlay}{Degree of overlay for ggridges}

\item{pos.thr}{Threshold for positive signatures used in scGate model (set to NULL to disable)}

\item{neg.thr}{Threshold for negative signatures used in scGate model (set to NULL to disable)}

\item{ncol}{Number of columns in output object (passed to wrap_plots)}

\item{combine}{Whether to combine plots into a single object, or to return a list of plots}
}
\value{
Returns a density plot of UCell scores for the signatures in the scGate model,
    for each level of the model

Either a plot combined by patchwork (combine=T) or a list of plots (combine=F)
}
\description{
Show distribution of UCell scores for each level of a given scGate model
}
\examples{
scGate.model.db <- get_scGateDB()
model <- scGate.model.db$human$generic$Tcell
# Apply scGate with this model
data(query.seurat)
query.seurat <- scGate(query.seurat, model=model,
    reduction="pca", save.levels=TRUE)
# View UCell score distribution
plot_UCell_scores(query.seurat, model)
}
