% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scDHA.R
\name{scDHA}
\alias{scDHA}
\title{scDHA}
\usage{
scDHA(
  data = data,
  k = NULL,
  method = "scDHA",
  sparse = FALSE,
  n = 5000,
  ncores = 10L,
  gen_fil = TRUE,
  do.clus = TRUE,
  sample.prob = NULL,
  seed = NULL
)
}
\arguments{
\item{data}{Gene expression matrix, with rows represent samples and columns represent genes.}

\item{k}{Number of clusters, leave as default for auto detection. Has no effect when \code{do.clus = False}.}

\item{method}{Method used for clustering. It can be "scDHA" or "louvain". The default setting is "scDHA".}

\item{sparse}{Boolen variable indicating whether data is a sparse matrix. The input must be a non negative sparse matrix.}

\item{n}{Number of genes to keep after feature selection step.}

\item{ncores}{Number of processor cores to use.}

\item{gen_fil}{Boolean variable indicating whether to perform scDHA gene filtering before performing dimension deduction and clustering.}

\item{do.clus}{Boolean variable indicating whether to perform scDHA clustering. If \code{do.clus = False}, only dimension deduction is performed.}

\item{sample.prob}{Probability used for classification application only. Leave this parameter as default, no user input is required.}

\item{seed}{Seed for reproducibility.}
}
\value{
List with the following keys:
\itemize{
\item cluster - A numeric vector containing cluster assignment for each sample. If \code{do.clus = False}, this values is always \code{NULL}.
\item latent - A matrix representing compressed data from the input data, with rows represent samples and columns represent latent variables.
}
}
\description{
The main function to perform dimension deduction and clustering.
}
\examples{
\donttest{
library(scDHA)
#Load example data (Goolam dataset)
data('Goolam'); data <- t(Goolam$data); label <- as.character(Goolam$label)
#Log transform the data 
data <- log2(data + 1)
if(torch::torch_is_installed()) #scDHA need libtorch installed
{
  #Generate clustering result, the input matrix has rows as samples and columns as genes
  result <- scDHA(data, ncores = 2, seed = 1)
  #The clustering result can be found here 
  cluster <- result$cluster
}
}
}
