% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Rename_Clusters}
\alias{Rename_Clusters}
\title{Rename Cluster Seurat}
\usage{
Rename_Clusters(seurat_object, new_idents, meta_col_name = NULL, ...)
}
\arguments{
\item{seurat_object}{object name.}

\item{new_idents}{vector of new cluster names.  Must be equal to the length of current active.ident
in Seurat Object.  Will accept named vector (with old idents as names) or will name the new_idents vector internally.}

\item{meta_col_name}{(Optional).  Whether or not to create new named column in \code{Object@meta.data}
to store the old identities.}

\item{...}{Extra parameters passed to \code{\link[SeuratObject]{RenameIdents}}.}
}
\value{
Seurat Object with new identities placed in active.ident slot.
}
\description{
Wrapper function to rename active identities in Seurat Object with new idents.
}
\examples{
\dontrun{
obj <- Rename_Clusters(seurat_object = obj_name, new_idents = new_idents_vec,
meta_col_name = "Round01_Res0.6_Idents")
}

}
\concept{marker_annotation_util}
