% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object_Utilities.R
\name{Add_Top_Gene_Pct_Seurat}
\alias{Add_Top_Gene_Pct_Seurat}
\title{Add Percent of High Abundance Genes}
\usage{
Add_Top_Gene_Pct_Seurat(
  seurat_object,
  num_top_genes = 50,
  meta_col_name = NULL,
  assay = "RNA",
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{seurat_object}{object name.}

\item{num_top_genes}{An integer vector specifying the size(s) of the top set of high-abundance genes.
Used to compute the percentage of library size occupied by the most highly expressed genes in each cell.}

\item{meta_col_name}{name to use for new meta data column.  Default is "percent_topXX", where XX is
equal to the value provided to \code{num_top_genes}.}

\item{assay}{assay to use in calculation.  Default is "RNA".  \emph{Note} This should only be changed if
storing corrected and uncorrected assays in same object (e.g. outputs of both Cell Ranger and Cell Bender).}

\item{overwrite}{Logical.  Whether to overwrite existing an meta.data column.  Default is FALSE meaning that
function will abort if column with name provided to \code{meta_col_name} is present in meta.data slot.}

\item{verbose}{logical, whether to print messages with status updates, default is TRUE.}
}
\value{
A Seurat Object
}
\description{
Add the percentage of counts occupied by the top XX most highly expressed genes in each cell.
}
\examples{
\dontrun{
library(Seurat)
pbmc_small <- Add_Top_Gene_Pct_Seurat(seurat_object = pbmc_small, num_top_genes = 50)
}

}
\references{
This function uses scuttle package (license: GPL-3) to calculate the percent of expression
coming from top XX genes in each cell.  Parameter description for \code{num_top_genes} also from scuttle.
If using this function in analysis, in addition to citing scCustomize, please cite scuttle:
McCarthy DJ, Campbell KR, Lun ATL, Willis QF (2017). “Scater: pre-processing, quality control,
normalisation and visualisation of single-cell RNA-seq data in R.” Bioinformatics, 33, 1179-1186.
\url{doi:10.1093/bioinformatics/btw777}.
}
\seealso{
\url{https://bioconductor.org/packages/release/bioc/html/scuttle.html}
}
\concept{qc_util}
