% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Replace_Suffix}
\alias{Replace_Suffix}
\title{Replace barcode suffixes}
\usage{
Replace_Suffix(data, current_suffix, new_suffix)
}
\arguments{
\item{data}{Either matrix/data.frame or list of matrices/data.frames with the cell barcodes in the column names.}

\item{current_suffix}{a single value or vector of values representing current barcode suffix.
If suffix is the same for all matrices/data.frames in list only single value is required.}

\item{new_suffix}{a single value or vector of values representing new barcode suffix to be added.
If desired suffix is the same for all matrices/data.frames in list only single value is required.
If no suffix is desired set \code{new_suffix = ""}.`}
}
\value{
matrix or data.frame with new column names.
}
\description{
Replace barcode suffixes in matrix, data.frame, or list of matrices/data.frames
}
\examples{
\dontrun{
dge_matrix <- Replace_Suffix(data = dge_matrix, current_suffix = "-1", new_suffix = "-2")
}

}
\concept{helper_util}
