% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Iterative_Plotting.R
\name{Iterate_FeaturePlot_scCustom}
\alias{Iterate_FeaturePlot_scCustom}
\title{Iterative Plotting of Gene Lists using Custom FeaturePlots}
\usage{
Iterate_FeaturePlot_scCustom(
  seurat_object,
  gene_list,
  colors_use = viridis_plasma_dark_high,
  na_color = "lightgray",
  na_cutoff = 1e-09,
  split.by = NULL,
  order = TRUE,
  return_plots = FALSE,
  file_path = NULL,
  file_name = NULL,
  file_type = NULL,
  single_pdf = FALSE,
  dpi = 600,
  pt.size = NULL,
  reduction = NULL,
  raster = NULL,
  alpha_exp = NULL,
  alpha_na_exp = NULL,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{gene_list}{vector of genes to plot.  If a named vector is provided then the names for each gene
will be incorporated into plot title if \code{single_pdf = TRUE} or into file name if \code{FALSE}.}

\item{colors_use}{color scheme to use.}

\item{na_color}{color for non-expressed cells.}

\item{na_cutoff}{Value to use as minimum expression cutoff.  To set no cutoff set to \code{NA}.}

\item{split.by}{Variable in \verb{@meta.data} to split the plot by.}

\item{order}{whether to move positive cells to the top (default = TRUE).}

\item{return_plots}{logical. Whether to return plots to list instead of saving them to file(s).  Default is FALSE.}

\item{file_path}{directory file path and/or file name prefix.  Defaults to current wd.}

\item{file_name}{name suffix and file extension.}

\item{file_type}{File type to save output as.  Must be one of following: ".pdf", ".png", ".tiff", ".jpeg", or ".svg".}

\item{single_pdf}{saves all plots to single PDF file (default = FALSE).  `file_type`` must be .pdf.}

\item{dpi}{dpi for image saving.}

\item{pt.size}{Adjust point size for plotting.}

\item{reduction}{Dimensionality Reduction to use (if NULL then defaults to Object default).}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{alpha_exp}{new alpha level to apply to expressing cell color palette (\code{colors_use}).  Must be
value between 0-1.}

\item{alpha_na_exp}{new alpha level to apply to non-expressing cell color palette (\code{na_color}).  Must be
value between 0-1.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{FeaturePlot}}.}
}
\value{
Saved plots
}
\description{
Create and Save plots for Gene list with Single Command
}
\examples{
\dontrun{
Iterate_FeaturePlot_scCustom(seurat_object = object, gene_list = DEG_list,
colors_use = viridis_plasma_dark_high, na_color = "lightgray", file_path = "plots/",
file_name = "tsne", file_type = ".jpg", dpi = 600)
}

}
\concept{iterative_plotting}
