% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_move.R
\name{item_move}
\alias{item_move}
\title{Move item from one folder to another}
\usage{
item_move(sb_id, id_new, ..., session = current_session())
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{id_new}{Folder/item to move \code{id} to. A ScienceBase ID or something 
that can be coerced to a SB item ID by \code{\link{as.sbitem}}}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
An object of class \code{sbitem}. Same as \code{id}, but with new 
parent id
}
\description{
Move item from one folder to another
}
\examples{
\dontrun{
# create 1st folder
(fold1 <- folder_create(user_id(), "bear123"))
(res <- item_create(fold1, "item-to-move"))

# create 2nd folder
(fold2 <- folder_create(user_id(), "bear456"))

# move item in 1st folder to 2nd folder
(res2 <- item_move(res, fold2))

# test identical
identical(res2$parentId, fold2$id)
}
}

