% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_sim.r
\name{summarise_data}
\alias{summarise_data}
\title{Summarise the model simulation repeats in a single file.}
\usage{
summarise_data(inputdir, model, outputfile, column_to_read = "X1")
}
\arguments{
\item{inputdir}{the input directory containing the time course files}

\item{model}{the model name}

\item{outputfile}{the name of the file to store the simulations}

\item{column_to_read}{the name of the column to process}
}
\description{
Summarise the model simulation repeats in a single file.
}
\examples{
data(insulin_receptor_1)
data(insulin_receptor_2)
data(insulin_receptor_3)
dir.create(file.path("sim_datasets"))
dir.create(file.path("sim_datasets_sum"))
write.table(insulin_receptor_1, 
            file=file.path("sim_datasets","insulin_receptor_1.csv"), 
            row.names=FALSE)
write.table(insulin_receptor_2, 
            file=file.path("sim_datasets","insulin_receptor_2.csv"), 
            row.names=FALSE)
write.table(insulin_receptor_3, 
            file=file.path("sim_datasets","insulin_receptor_3.csv"), 
            row.names=FALSE)
summarise_data(inputdir="sim_datasets", 
               model="insulin_receptor", 
               outputfile=file.path("sim_datasets_sum", 
                                    "insulin_receptor_IR_beta_pY1146.csv"), 
               column_to_read="IR_beta_pY1146")
}
