% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-SBM.R
\name{SBM}
\alias{SBM}
\title{R6 virtual class for SBM representation (mother class of Simple and Bipartite SBM fit and sampler)}
\description{
R6 virtual class for SBM representation (mother class of Simple and Bipartite SBM fit and sampler)

R6 virtual class for SBM representation (mother class of Simple and Bipartite SBM fit and sampler)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{dimension}}{size-2 vector: dimension of the network}

\item{\code{modelName}}{character, the family of model for the distribution of the edges}

\item{\code{dimLabels}}{vector of characters, the label of each dimension}

\item{\code{nbCovariates}}{integer, the number of covariates}

\item{\code{blockProp}}{vector of block proportions (aka prior probabilities of each block)}

\item{\code{connectParam}}{parameters associated to the connectivity of the SBM, e.g. matrix of inter/inter block probabilities when model is Bernoulli}

\item{\code{covarParam}}{vector of regression parameters associated with the covariates.}

\item{\code{covarList}}{list of matrices of covariates}

\item{\code{covarArray}}{the array of covariates}

\item{\code{covarEffect}}{effect of covariates}

\item{\code{netMatrix}}{the matrix (adjacency or incidence) encoding the network}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SBM$new()}}
\item \href{#method-plot}{\code{SBM$plot()}}
\item \href{#method-show}{\code{SBM$show()}}
\item \href{#method-print}{\code{SBM$print()}}
\item \href{#method-clone}{\code{SBM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for SBM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$new(
  model = "",
  dimension = numeric(2),
  dimLabels = vector("list", 2),
  blockProp = numeric(0),
  connectParam = list(mean = matrix()),
  covarParam = numeric(length(covarList)),
  covarList = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{character describing the type of model}

\item{\code{dimension}}{dimension of the network matrix}

\item{\code{dimLabels}}{labels of each dimension (in row, in columns)}

\item{\code{blockProp}}{parameters for block proportions (vector of list of vectors)}

\item{\code{connectParam}}{list of parameters for connectivity}

\item{\code{covarParam}}{optional vector of covariates effect}

\item{\code{covarList}}{optional list of covariates data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
basic matrix plot method for SBM object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$plot(type = c("data", "expected"), ordered = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character for the type of plot: either 'data' (true connection) or 'expected' (fitted connection). Default to 'data'.}

\item{\code{ordered}}{logical: should the rows and columns be reordered according to the clustering? Default to \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a ggplot2 object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$show(type = "Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character to tune the displayed name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
