% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convRad2BT.R
\docType{methods}
\name{convRad2BT}
\alias{convRad2BT}
\alias{convRad2BT,RasterLayer-method}
\alias{convRad2BT,RasterStack-method}
\alias{convRad2BT,Satellite-method}
\title{Convert a band's scaled counts to brightness temperature}
\usage{
\S4method{convRad2BT}{Satellite}(x)

\S4method{convRad2BT}{RasterStack}(x, k1, k2)

\S4method{convRad2BT}{RasterLayer}(x, k1, k2)
}
\arguments{
\item{x}{An object of class Satellite, raster::RasterStack or
raster::RasterLayer providing radiance values.}

\item{k1,k2}{Temperature correction parameters.}
}
\value{
If x is a Satellite object, a Satellite object with added converted
layers; \cr
if x is a \code{raster::Raster*} object, a \code{raster::Raster*} object with
converted layer(s).
}
\description{
Convert a band's radiance values to brightness temperature without
any kind of atmospheric correction etc.






}
\details{
The conversion functions are taken from USGS' Landsat 8 manual
which is available online at
\url{http://landsat.usgs.gov/Landsat8_Using_Product.php}.
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC8*.tif"), full.names = TRUE)
sat <- satellite(files)
sat <- convRad2BT(sat)
}
\seealso{
\code{\link{calcAtmosCorr}} for converions of scaled counts
to physical units including a scene-based atmospheric correction.
}

