% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar_threshold.R
\name{get_coef}
\alias{get_coef}
\title{Calculate the intercepts and slopes of the different segments}
\usage{
get_coef(fit)
}
\arguments{
\item{fit}{An object of class 'thresholds', generated using the
\code{\link{sar_threshold}} function.}
}
\value{
A dataframe with the intercepts (ci) and slopes (zi) of all segments
  in each fitted model. The numbers attached to c and z relate to the
  segment, e.g. c1 and z1 are the intercept and slope of the first segment.
  For the left-horizontal models, the slope of the first segment (i.e. the
  horizontal segment) is not returned. NA values represent cases where a
  given parameter is not present in a particular model.
}
\description{
Calculate the intercepts and slopes of the different segments in
  any of the fitted breakpoint regression models available in the package.
}
\details{
The coefficients in the fitted breakpoint regression models do not
  all represent the intercepts and slopes of the different segments; to get
  these it is necessary to add different coefficients together.
}
\examples{
data(aegean2)
a2 <- aegean2[1:168,]
fitT <- sar_threshold(data = a2, mod = c("ContOne", "DiscOne", "ZslopeOne"),
interval = 0.1, non_th_models = TRUE, logAxes = "area", logT = log10)
#get the slopes and intercepts for these three models
coefs <- get_coef(fitT)
coefs
}
