% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeRTA.R
\name{computeRTA}
\alias{computeRTA}
\title{Compute Relative Threshold Sum approach (RTA)}
\usage{
computeRTA(profile, target = c("interface", "layer"))
}
\arguments{
\item{profile}{a \link{snowprofile} object, whose layer properties are entirely known (i.e., no NAs in gtype, hardness, gsize allowed!)}

\item{target}{Do you want to compute the index for the layers or for the layer interfaces? defaults to both.}
}
\value{
the snowprofile object is returned with new layer properties describing the index. The index ranges between \verb{[0, 1]}, whereas values > 0.8
indicate structurally unstable layers/interfaces.
}
\description{
Monti, F., & Schweizer, J. (2013). A relative difference approach to detect potential weak layers within a snow profile.
Proceedings of the 2013 International Snow Science Workshop, Grenoble, France, 339–343. Retrieved from https://arc.lib.montana.edu/snow-science/item.php?id=1861
}
\examples{
sp <- computeRTA(SPpairs$B_modeled1)
plot(sp, TempProfile = FALSE, main = "RTA")
lines(sp$layers$rta*5, sp$layers$height - 0.5*sp$layers$thickness, type = "b", xlim = c(0, 5))
lines(sp$layers$rta_interface*5, sp$layers$height, type = "b", xlim = c(0, 5), col = "red")
abline(h = sp$layers$height, lty = "dotted", col = "grey")
abline(v = 0.8*5, lty = "dashed")

}
\seealso{
\link{computeTSA}
}
\author{
fherla
}
