% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_prop_plot_html.R
\name{embed_cat_prop_plot}
\alias{embed_cat_prop_plot}
\title{Embed Interactive Categorical Plot}
\usage{
embed_cat_prop_plot(
  data,
  ...,
  dep = tidyselect::everything(),
  indep = NULL,
  colour_palette = NULL,
  mesos_group = NULL,
  html_interactive = TRUE,
  inverse = FALSE,
  call = rlang::caller_env()
)
}
\arguments{
\item{data}{\emph{Survey data}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

A data frame (or a srvyr-object) with the columns specified in the
chapter_overview 'dep_cat', etc columns.}

\item{...}{\emph{Dynamic dots}

<\href{https://rlang.r-lib.org/reference/dyn-dots.html}{\code{dynamic-dots}}>

Arguments forwarded to the corresponding functions that create the elements.}

\item{dep, indep}{\emph{Variable selections}

<\code{tidyselect}> // \emph{Default:} \code{NULL}, meaning everything for dep, nothing for indep.

Columns in \code{data}. Currently allows tidyselect-syntax, which will be removed.}

\item{colour_palette}{Character vector of colour codes.}

\item{mesos_group}{\emph{Specific group to compare with}

\verb{scalar<character>} // \emph{Default:} \code{NULL} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}

\item{html_interactive}{\emph{Toggle interactive plot}

\verb{scalar<logical>} // \emph{default:} \code{TRUE} (\code{optional})

Whether plot is to be interactive (ggiraph) or static (ggplot2).}

\item{inverse}{Flag, defaults to FALSE. If TRUE, swaps x-axis and faceting.}

\item{call}{\emph{Internal call}

\verb{obj:<call>} // \emph{Default:} \code{rlang::caller_env()} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}
}
\value{
ggplot
}
\description{
Embed Interactive Categorical Plot
}
\examples{
\donttest{
embed_cat_prop_plot(data = ex_survey, dep = b_1:b_3)
}
}
