% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_qmd_index.R
\name{gen_qmd_index}
\alias{gen_qmd_index}
\title{Generate Quarto Index File That Merges All Chapters}
\usage{
gen_qmd_index(
  index_filepath = "index.qmd",
  ...,
  chapter_filepaths = NULL,
  report_filepath = NULL,
  yaml_file = NULL,
  call = rlang::caller_env()
)
}
\arguments{
\item{index_filepath}{Path to the output index.qmd file. Defaults to "complete_report.qmd"}

\item{...}{\emph{Dynamic dots}

<\href{https://rlang.r-lib.org/reference/dyn-dots.html}{\code{dynamic-dots}}>

Arguments forwarded to the corresponding functions that create the elements.}

\item{chapter_filepaths}{A character vector containing the filepaths of the chapter files to be included in the index, in the desired order.}

\item{report_filepath}{A string containing the filepath to the report.qmd.}

\item{yaml_file}{A string containing the filepath to a yaml-file to be inserted at top of qmd-file.}

\item{call}{Internal call argument. Not to be fiddled with by the user.}
}
\value{
A string containing the filepath to the generated Quarto index file.
}
\description{
This function creates an index Quarto file (QMD) that merges all chapters in the specified order. It can also include optional title and author(s) information.
}
\keyword{internal}
