% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_data_methods.R
\name{initialize,sfn_data-method}
\alias{initialize,sfn_data-method}
\title{Initialize method for sfn_data}
\usage{
\S4method{initialize}{sfn_data}(
  .Object,
  sapf_data,
  env_data,
  sapf_flags,
  env_flags,
  si_code,
  timestamp,
  solar_timestamp,
  site_md,
  stand_md,
  species_md,
  plant_md,
  env_md
)
}
\arguments{
\item{.Object}{sfn_data object to create}

\item{sapf_data}{A tibble (or any object coercible to one) with the sapf_data
(without the TIMESTAMP variable)}

\item{env_data}{A tibble (or any object coercible to one) with the env_data
(without the TIMESTAMP variable)}

\item{sapf_flags}{A tibble (or any object coercible to one) with the same
dimensions of \code{sapf_data} with the flag info for each tree/TIMESTAMP
combination}

\item{env_flags}{A tibble (or any object coercible to one) with the same
dimensions of \code{env_data} with the flag info for each env_var/TIMESTAMP
combination}

\item{si_code}{A character vector of length one indicating
the site code}

\item{timestamp}{A POSIXct vector of length \code{nrow(sapf_data)} with the
timestamp}

\item{solar_timestamp}{A POSIXct vector of length \code{nrow(sapf_data)} with
the solar timestamp}

\item{site_md}{A tibble (or any object coercible to one) containing the site
metadata}

\item{stand_md}{A tibble (or any object coercible to one) containing the stand
metadata}

\item{species_md}{A tibble (or any object coercible to one) containing the species
metadata}

\item{plant_md}{A tibble (or any object coercible to one) containing the plant
metadata}

\item{env_md}{A tibble (or any object coercible to one) containing the env
metadata}
}
\description{
Initialize an sfn_data object
}
