% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_data_methods.R
\docType{methods}
\name{sfn_get_methods}
\alias{sfn_get_methods}
\alias{get_sapf_data,sfn_data-method}
\alias{get_env_data,sfn_data-method}
\alias{get_sapf_flags,sfn_data-method}
\alias{get_env_flags,sfn_data-method}
\alias{get_timestamp,sfn_data-method}
\alias{get_solar_timestamp,sfn_data-method}
\alias{get_si_code,sfn_data-method}
\alias{get_site_md,sfn_data-method}
\alias{get_stand_md,sfn_data-method}
\alias{get_species_md,sfn_data-method}
\alias{get_plant_md,sfn_data-method}
\alias{get_env_md,sfn_data-method}
\title{sfn_data get methods}
\usage{
\S4method{get_sapf_data}{sfn_data}(object, solar = FALSE)

\S4method{get_env_data}{sfn_data}(object, solar = FALSE)

\S4method{get_sapf_flags}{sfn_data}(object, solar = FALSE)

\S4method{get_env_flags}{sfn_data}(object, solar = FALSE)

\S4method{get_timestamp}{sfn_data}(object)

\S4method{get_solar_timestamp}{sfn_data}(object)

\S4method{get_si_code}{sfn_data}(object)

\S4method{get_site_md}{sfn_data}(object)

\S4method{get_stand_md}{sfn_data}(object)

\S4method{get_species_md}{sfn_data}(object)

\S4method{get_plant_md}{sfn_data}(object)

\S4method{get_env_md}{sfn_data}(object)
}
\arguments{
\item{object}{Object of class sfn_data from which data is retrieved}

\item{solar}{Logical indicating if the timestamp to return in the \code{get_sapf_data},
\code{get_env_data}, \code{get_sapf_flags} and \code{get_env_flags} methods is
the solarTIMESTAMP (TRUE) or the contributors provided TIMESTAMP (FALSE)}
}
\description{
Methods to get the data and metadata from the sfn_data class slots
}
\details{
\code{get_sapf_data} and \code{get_env_data} methods retrieve sapflow or environmental
tibbles to create a functional dataset to work with.

\code{get_sapf_flags} and \code{get_env_flags} methods retrieve sapflow or
environmental flags as tibbles.

\code{get_timestamp} and \code{get_solar_timestamp} methods retrieve only the
timestamp as POSIXct vector.

\code{get_si_code} method retrieve a character vector with length(timestamp)
containing the site code.

\code{get_site_md}, \code{get_stand_md}, \code{get_species_md},
\code{get_plant_md} and \code{get_env_md} methods retrieve the corresponding
metadata.
}
\examples{
library(dplyr)

data('ARG_TRE', package = 'sapfluxnetr')
sapf_data <- get_sapf_data(ARG_TRE, solar = TRUE)
env_data_no_solar <- get_env_data(ARG_TRE, solar = FALSE)
plant_md <- get_plant_md(ARG_TRE)

# dplyr pipe to get the mean dbh for a site
ARG_TRE \%>\%
  get_plant_md() \%>\%
  summarise(dbh_mean = mean(pl_dbh, na.rm = TRUE)) \%>\%
  pull(dbh_mean)

}
