% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{scaling_mean}
\alias{scaling_mean}
\title{Mean scaling of each column}
\usage{
scaling_mean(inputMat)
}
\arguments{
\item{inputMat}{(Observation x Variable) \code{data.frame} of measurements, with observations as rows and different variables as columns.}
}
\value{
Matrix of measurements mean-scaled columnwise.
}
\description{
Scale each variable (column) by the mean. Mean-scaling applied as (value - mean) / mean.
As \code{\link{scaling_UV}} might give too much importance to flat trajectories due to the division by the standard deviation, by dividing by the mean, high intensity values will have a lower influence and the low intensity will be boosted.
}
\examples{
\donttest{
inputMat <- data.frame(matrix(c(1,4,7, 8,4,0, 3,6,9), nrow=3))
scaling_mean(inputMat)
#          X1 X2  X3
# [1,] -0.75  1 -0.5
# [2,]  0.00  0  0.0
# [3,]  0.75 -1  0.5
}
}
