% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratacostsamplesize.R
\name{stratacostsamplesize}
\alias{stratacostsamplesize}
\title{Strata sample size by costs function}
\usage{
stratacostsamplesize(Nh, C, cini, ch, alloc = c("unif", "prop"))
}
\arguments{
\item{Nh}{Vector of population strata sizes.}

\item{C}{Total study cost.}

\item{cini}{Overhead study cost.}

\item{ch}{Vector of costs to take an individual from a strata for the sample.}

\item{alloc}{The allocation method to be used. Default is "unif".}
}
\value{
Sample size.
}
\description{
This function returns the total sample size given a costs function
consisting on the fixed total study cost, overhead study cost and a vector of costs by strata.
can be given so the allocation is calculated to not exceed the total study cost.
}
\details{
Sample size of "min" and "optim" allocations for a given costs function
is the same and equal to the sum of \code{\link{stratacostallocation}} return
values with the same costs function.
}
\examples{
stratacostsamplesize(Nh=c(100,500,200), C=1000, cini=70, ch=c(9,5,12) ,alloc="prop")
}
