% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratacostallocation.R
\name{stratacostallocation}
\alias{stratacostallocation}
\title{Strata allocation by costs function}
\usage{
stratacostallocation(Nh, n, var, C, cini, ch)
}
\arguments{
\item{Nh}{Vector of population strata sizes.}

\item{n}{Sample size.}

\item{var}{Vector of strata variances.}

\item{C}{Total study cost.}

\item{cini}{Overhead study cost.}

\item{ch}{Vector of costs to take an individual from a strata for the sample.}
}
\value{
Vector of strata sample sizes.
}
\description{
This function returns the optimum allocation by strata given a
vector of costs by strata. Optionally the fixed total study cost and overhead study cost
can be given so the allocation is calculated to not exceed the total study cost.
}
\examples{
stratacostallocation(rep(125,4),50,c(458,313,407,364),C=25000,cini=2000,ch=c(100,150,20,200))
}
