% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{distribution}
\alias{distribution}
\alias{distribution,samc,missing,missing,missing,numeric-method}
\alias{distribution,samc,missing,location,missing,numeric-method}
\alias{distribution,samc,missing,missing,location,numeric-method}
\alias{distribution,samc,missing,location,location,numeric-method}
\alias{distribution,samc,RasterLayer,missing,missing,numeric-method}
\alias{distribution,samc,matrix,missing,missing,numeric-method}
\title{Calculate distribution metrics}
\usage{
distribution(samc, occ, origin, dest, time)

\S4method{distribution}{samc,missing,missing,missing,numeric}(samc, time)

\S4method{distribution}{samc,missing,location,missing,numeric}(samc, origin, time)

\S4method{distribution}{samc,missing,missing,location,numeric}(samc, dest, time)

\S4method{distribution}{samc,missing,location,location,numeric}(samc, origin, dest, time)

\S4method{distribution}{samc,RasterLayer,missing,missing,numeric}(samc, occ, time)

\S4method{distribution}{samc,matrix,missing,missing,numeric}(samc, occ, time)
}
\arguments{
\item{samc}{A \code{\link{samc-class}} object. This should be output from
the \code{\link{samc}} function.}

\item{occ}{A \code{\link[raster]{RasterLayer-class}} or \code{\link[base]{matrix}}.
The input type must match the input type used to create the
\code{\link{samc-class}} object, and must have the same properties as the
rest of the landscape data. See the \code{\link{check}} function for more
details.}

\item{origin}{A positive integer or named location representing a cell in the
landscape. Corresponds to row \emph{i} of matrix \emph{P} in the \code{\link{samc-class}}
object. When paired with the dest parameter, multiple values may be provided
as a vector.}

\item{dest}{A positive integer or named location representing a cell in the
landscape. Corresponds to column \emph{j} of matrix \emph{P} in the \code{\link{samc-class}}
object. When paired with the origin parameter, multiple values may be provided
as a vector.}

\item{time}{A positive integer or a vector of positive integers representing
time steps. Vectors must be ordered and contain no duplicates. Vectors may
not be used for metrics that return dense matrices. The maximum time step
value is capped at 10,000.}
}
\value{
A \code{vector}
}
\description{
Calculate the probability of finding an individual at a given location at a
specific time.
}
\details{
\eqn{Q^t}
\itemize{
  \item \strong{distribution(samc, time)}

The result is a matrix where element (i,j) is the probability of being
at location j after t time steps if starting at location i.

The returned matrix will always be dense and cannot be optimized. Must enable
override to use.

  \item \strong{distribution(samc, origin, time)}

The result is a vector (single time step) or a list of vectors (multiple time steps)
where element j is the probability of being at location j after t time steps if
starting at a given origin.

  \item \strong{distribution(samc, dest, time)}

The result is a vector where element i is the probability of being
at a given destination after t time steps if starting at location i.

  \item \strong{distribution(samc, origin, dest, time)}

The result is a numeric value (single time step) or a list of numeric values
(multiple time steps) that is the probability of being at a given
destination after t time steps when beginning at a given origin.
}

\eqn{\psi^TQ^t}
\itemize{
  \item \strong{distribution(samc, occ, time)}

The result is a vector (single time step) or a list of vectors (multiple
time steps) where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element \emph{i} is the unconditional
probability of finding an individual (or expected number of individuals) in
location \emph{i} after \emph{t} time steps.
}
}
\section{Performance}{


Any relevant performance information about this function can be found in the
performance vignette: \href{../doc/performance.html}{\code{vignette("performance", package = "samc")}}
}

\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::ex_res_data
abs_data <- samc::ex_abs_data
occ_data <- samc::ex_occ_data


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, occ_data)


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers. If using RasterLayers, the latlon parameter must be set.
samc_obj <- samc(res_data, abs_data, tr_fun = function(x) 1/mean(x))


# Convert the occupancy data to probability of occurrence
occ_prob_data <- occ_data / sum(occ_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, occ_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, occ_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
