% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visitation.R
\docType{methods}
\name{visitation}
\alias{visitation}
\alias{visitation,samc,missing,missing-method}
\alias{visitation,samc,numeric,missing-method}
\alias{visitation,samc,missing,numeric-method}
\alias{visitation,samc,numeric,numeric-method}
\title{Calculate visitation metrics}
\usage{
visitation(samc, origin, dest)

\S4method{visitation}{samc,missing,missing}(samc)

\S4method{visitation}{samc,numeric,missing}(samc, origin)

\S4method{visitation}{samc,missing,numeric}(samc, dest)

\S4method{visitation}{samc,numeric,numeric}(samc, origin, dest)
}
\arguments{
\item{samc}{A \code{\link{samc-class}} object. This should be output from
the \code{\link{samc}} function.}

\item{origin}{A positive integer representing a cell in the landscape,
excluding \code{NA} cells. Corresponds to row \emph{i} of matrix \emph{P}
in the \code{\link{samc-class}} object.}

\item{dest}{A positive integer representing a cell in the landscape,
excluding \code{NA} cells. Corresponds to column \emph{j} of matrix \emph{P}
in the \code{\link{samc-class}} object.}
}
\value{
A matrix, a vector, or a numeric
}
\description{
Calculates the number of times that individuals from each location visit each
location in the landscape before death.
}
\details{
\eqn{F = (I-Q)^{-1}}
\itemize{
  \item \strong{visitation(samc)}

The result is a matrix where element (\emph{i},\emph{j}) is the expected
number of times an individual that starts in \emph{i} uses \emph{j} before it
dies.

The returned matrix will always be dense and cannot be optimized. Must enable
override to use.

\item \strong{visitation(samc, origin)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element \emph{j} is the number of times that an
individual starting at the origin visits location \emph{j} before it dies.

\item \strong{visitation(samc, dest)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element \emph{i} is the number of times that an
individual starting at location \emph{i} visits the destination before it
dies.

\item \strong{visitation(samc, origin, dest)}

The result is a numeric value that is the expected number of times an
individual starting at the origin visits the destination before it dies.
}
}
\section{Performance}{


Any relevant performance information about this function can be found in the
performance vignette: \href{../doc/performance.html}{\code{vignette("performance", package = "samc")}}
}

\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::ex_res_data
abs_data <- samc::ex_abs_data
occ_data <- samc::ex_occ_data


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, occ_data)


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers. If using RasterLayers, the latlon parameter must be set.
samc_obj <- samc(res_data, abs_data, tr_fun = function(x) 1/mean(x))


# Convert the occupancy data to probability of occurrence
occ_prob_data <- occ_data / sum(occ_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, occ_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, occ_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
