% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{sm_series}
\alias{sm_series}
\title{Retrieve Series Table}
\usage{
sm_series(
  dsid = NULL,
  series = NULL,
  dataset.info = FALSE,
  ordered = TRUE,
  return.query = FALSE
)
}
\arguments{
\item{dsid}{character. (Optional) id's of datasources matching the 'dsid' column of the 'DATASET' table (retrieved using \code{\link[=sm_datasets]{sm_datasets()}}) for which series information is to be returned.}

\item{series}{character. (Optional) codes of series for which information in to be returned. If 'dsid' is also specificed, the two are combined using SQL 'OR' i.e. these series are retrieved in addition to all series matched through 'dsid'.}

\item{dataset.info}{logical. \code{TRUE} returns additional information from the 'DATASET' table (the dataset name, when data was last updated, the source id and the data provider and access mode).}

\item{ordered}{logical. \code{TRUE} returns the series in a fixed order, while \code{FALSE} returns the result in a random order, to the benefit of faster query execution.}

\item{return.query}{logical. \code{TRUE} will not query the database but instead return the constructed SQL query as a character string (for debugging purposes).}
}
\value{
A \code{\link[data.table]{data.table}} with information about the available series in the database.
}
\description{
This function pulls the 'SERIES' table from the database, providing information about the time series in the database. Each series is given a code which unique across datasets.
}
\details{
Each series is given a code which is unique across datasets.
Each series also has a label describing the series. Further information recorded are the series frequency, unit, whether it was seasonally adjusted, number of observations,
minimum and maximum date, and (optionally) topic, alternative code provided by the data source (data retrieved from EconData uses EconData codes as series codes, so the 'src_code'
field gives the codes used by the SARB or STATSSA), or further comments on the series.
}
\examples{
\donttest{
# By default returns all series
sm_series()

# Adding information about the dataset and provider
sm_series(dataset.info = TRUE)

# Only series in the QB
sm_series("QB")
}
}
\seealso{
\code{\link{sm_datasources}}, \code{\link{sm_datasets}}, \code{\link{sm_data}}, \code{\link{samadb}}
}
