% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_describe_report_type}
\alias{sf_describe_report_type}
\title{Describe a report type}
\usage{
sf_describe_report_type(report_type, verbose = FALSE)
}
\arguments{
\item{report_type}{\code{character}; a character representing the type of
report to retrieve the metadata information on. A list of valid report types
that can be described using this function will be available in the
\code{reportTypes.type} column of results returned \link{sf_list_report_types}.
(e.g. \code{AccountList}, \code{AccountContactRole}, \code{OpportunityHistory},
etc.)}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{list} containing up to 4 properties that describe the report:
\describe{
\item{attributes}{Report type along with the URL to retrieve common objects and
joined metadata.}
\item{reportMetadata}{Unique identifiers for groupings and summaries.}
\item{reportTypeMetadata}{Fields in each section of a report type plus filter information for those fields.}
\item{reportExtendedMetadata}{Additional information about summaries and groupings.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Return metadata about a report type.
}
\section{Salesforce Documentation}{

\itemize{
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/analytics_api_reporttypes_reference_reporttype.htm}{Documentation}
}
}

\examples{
\dontrun{
reports <- sf_list_report_types()
unique_report_types <- reports \%>\% distinct(reportTypes.type)

# first unique report type
unique_report_types[[1,1]]

# describe that report type
described_report <- sf_describe_report_type(unique_report_types[[1,1]])
}
}
\seealso{
Other Report functions: 
\code{\link{sf_copy_report}()},
\code{\link{sf_create_report}()},
\code{\link{sf_delete_report}()},
\code{\link{sf_describe_report}()},
\code{\link{sf_execute_report}()},
\code{\link{sf_list_report_fields}()},
\code{\link{sf_list_report_filter_operators}()},
\code{\link{sf_list_report_types}()},
\code{\link{sf_list_reports}()},
\code{\link{sf_query_report}()},
\code{\link{sf_run_report}()},
\code{\link{sf_update_report}()}
}
\concept{Report functions}
