% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{sf_query}
\alias{sf_query}
\title{Perform SOQL Query}
\usage{
sf_query(soql, object_name, queryall = FALSE, guess_types = TRUE,
  api_type = c("REST", "SOAP", "Bulk 1.0"), control = list(...), ...,
  next_records_url = NULL, verbose = FALSE)
}
\arguments{
\item{soql}{character; a string defining a SOQL query (e.g. "SELECT Id, Name FROM Account")}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{queryall}{logical; indicating if the query recordset should include records 
that have been deleted because of a merge or delete. QueryAll will also return 
information about archived Task and Event records. QueryAll is available in API 
version 29.0 and later.}

\item{guess_types}{logical; indicating whether or not to use \code{col_guess()} 
to try and cast the data returned in the query recordset. TRUE uses \code{col_guess()} 
and FALSE returns all values as character strings.}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{control}{\code{list}; a list of parameters for controlling the behavior of 
the API call being used. For more information of what parameters are available 
look at the documentation for \code{\link{sf_control}}}

\item{...}{arguments passed to \code{\link{sf_control}} or further downstream 
to \code{\link{sf_query_bulk}}.}

\item{next_records_url}{character (leave as NULL); a string used internally 
by the function to paginate through to more records until complete}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} of records
}
\description{
Executes a query against the specified object and returns data that matches 
the specified criteria.
}
\note{
Bulk API query doesn't support the following SOQL:
\itemize{
   \item COUNT
   \item ROLLUP
   \item SUM
   \item GROUP BY CUBE
   \item OFFSET
   \item Nested SOQL queries
   \item Relationship fields
   }
Additionally, Bulk API can't access or query compound address or compound geolocation fields.
}
\examples{
\dontrun{
sf_query("SELECT Id, Account.Name, Email FROM Contact LIMIT 10")
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
