% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{generateNormalData}
\alias{generateNormalData}
\title{Generates Normally Distributed Data Depending on the Design}
\usage{
generateNormalData(
  nPlan,
  nSim = 1000L,
  deltaTrue = NULL,
  muGlobal = 0,
  sigmaTrue = 1,
  paired = FALSE,
  seed = NULL,
  muTrue = NULL
)
}
\arguments{
\item{nPlan}{vector of max length 2 representing the planned sample sizes.}

\item{nSim}{the number of replications, that is, experiments with max samples nPlan.}

\item{deltaTrue}{numeric, the value of the true standardised effect size (test-relevant parameter).}

\item{muGlobal}{numeric, the true global mean of a paired or two-sample t-test. Its value should not
matter for the test. This parameter is treated as a nuisance.}

\item{sigmaTrue}{numeric > 0,the true standard deviation of the data. Its value should not  matter
for the test.This parameter treated is treated as a nuisance.}

\item{paired}{logical, if \code{TRUE} then paired t-test.}

\item{seed}{To set the seed for the simulated data.}

\item{muTrue}{numeric representing the true mean for simulations with a z-test.
Default \code{NULL}}
}
\value{
Returns a list of two data matrices contains at least the following components:

\describe{
  \item{dataGroup1}{a matrix of data dimension nSim by \code{nPlan[1]}.}
  \item{dataGroup2}{a matrix of data dimension nSim by \code{nPlan[2]}.}
}
}
\description{
The designs supported are "oneSample", "paired", "twoSample".
}
\examples{
generateNormalData(20, 15, deltaTrue=0.3)
}
