% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R
\docType{data}
\name{epilepsy.saemix}
\alias{epilepsy.saemix}
\title{Epilepsy count data}
\source{
MASS package in R
}
\description{
The epilepsy data from Thall and Vail (1990), available from the MASS package, records two-week seizure counts for 59 epileptics.
The number of seizures was recorded for a baseline period of 8 weeks, and then patients were randomly assigned to a treatment group
or a control group. Counts were then recorded for four successive two-week periods. The subject's age is the only covariate. See the
documentation for epil in the MASS package for details on the dataset.
}
\examples{
# You need to have MASS installed to successfully run this example
if (requireNamespace("MASS")) {
  
  epilepsy<-MASS::epil
  saemix.data<-saemixData(name.data=epilepsy, name.group=c("subject"),
     name.predictors=c("period","y"),name.response=c("y"),
     name.covariates=c("trt","base", "age"), units=list(x="2-week",y="",covariates=c("","","yr")))
  ## Poisson model with one parameter
  countPoi<-function(psi,id,xidep) { 
    y<-xidep[,2]
    lambda<-psi[id,1]
    logp <- -lambda + y*log(lambda) - log(factorial(y))
    return(logp)
    }
 saemix.model<-saemixModel(model=countPoi,description="Count model Poisson",modeltype="likelihood", 
   psi0=matrix(c(0.5),ncol=1,byrow=TRUE,dimnames=list(NULL, c("lambda"))), transform.par=c(1))
 \donttest{
  saemix.options<-list(seed=632545,save=FALSE,save.graphs=FALSE, displayProgress=FALSE)
  poisson.fit<-saemix(saemix.model,saemix.data,saemix.options)
  }
}
  
}
\references{
P Thall, S Vail (1990). Some covariance models for longitudinal count data with overdispersion. Biometrics 46(3):657-71.
}
\keyword{datasets}
