% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SaemixObject.R
\docType{class}
\name{SaemixObject-class}
\alias{SaemixObject}
\alias{SaemixObject-class}
\alias{print,SaemixObject}
\alias{show,SaemixObject}
\alias{showall,SaemixObject}
\alias{summary,SaemixObject}
\title{Class "SaemixObject"}
\description{
An object of the SaemixObject class, storing the input to saemix, and the results obtained by a call
to the SAEM algorithm
}
\details{
Details of the algorithm can be found in the pdf file accompanying the package.
}
\section{Objects from the Class}{

An object of the SaemixObject class is created after a call to \code{\link{saemix}} and contain the following slots:
  \describe{
    \item{\code{data}:}{Object of class \code{"SaemixData"}: saemix dataset, created by a call to \code{saemixData}}
    \item{\code{model}:}{Object of class \code{"SaemixModel"}: saemix model, created by a call to \code{saemixModel}}
    \item{\code{results}:}{Object of class \code{"SaemixData"}: saemix dataset, created by a call to \code{saemixData}}
    \item{\code{rep.data}:}{Object of class \code{"SaemixRepData"}: (internal) replicated saemix dataset, used the execution of the algorithm}
    \item{\code{sim.data}:}{Object of class \code{"SaemixSimData"}: simulated saemix dataset}
    \item{\code{options}:}{Object of class \code{"list"}: list of settings for the algorithm}
    \item{\code{prefs}:}{Object of class \code{"list"}: list of graphical options for the graphs}
  }
}

\section{Methods}{

  \describe{
    \item{[<-}{\code{signature(x = "SaemixObject")}: replace elements of object}
    \item{[}{\code{signature(x = "SaemixObject")}: access elements of object}
    \item{initialize}{\code{signature(.Object = "SaemixObject")}: internal function to initialise object, not to be used}
    \item{plot}{\code{signature(x = "SaemixObject")}: plot the data}
    \item{print}{\code{signature(x = "SaemixObject")}: prints details about the object (more extensive than show)}
    \item{showall}{\code{signature(object = "SaemixObject")}: shows all the elements in the object}
    \item{show}{\code{signature(object = "SaemixObject")}: prints details about the object}
    \item{summary}{\code{signature(object = "SaemixObject")}: summary of the object. Returns a list with a number of elements extracted from the object.}
	 }
}
\examples{
showClass("SaemixObject")
}
\author{
Emmanuelle Comets \email{emmanuelle.comets@inserm.fr}

Audrey Lavenu

Marc Lavielle.
}
\references{
Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis (2005), 49(4):1020-38.

Comets E, Lavenu A, Lavielle M. Parameter Estimation in Nonlinear Mixed Effect Models Using saemix, an R Implementation of the SAEM Algorithm. Journal of Statistical Software (2017), 80(3):1-41. doi:10.18637/jss.v080.i03
}
\seealso{
\code{\link{SaemixData}} \code{\link{SaemixModel}} \code{\link{saemixControl}} \code{\link{saemix}}
\code{\link{plot.saemix}},
}
\keyword{classes}

