#' Synthetics Data for Small Area Estimation using Hierarchical Bayesian Method under Hurdle Negative Binomial Distribution
#'
#' @description Dataset to simulate Small Area Estimation using Hierarchical Bayesian Method under Hurdle Negative Binomial Distribution
#'
#' This data is generated by these following steps:
#'
#' \enumerate{
#'     \item Generate sampling random area effect for non-zero count \code{u} with  \code{u ~ N(0,1)}. The auxiliary variables are generated by \code{x1 ~ U(0,1)} and  \code{x2 ~ N(0,1)}. The coefficient parameters for non-zero count variable of interest \eqn{ \beta_{0}, \beta_{1}, and \beta_{2}}{\beta0, \beta1, \beta2} are set with a certain values, we set them equals to 1. Meanwhile, the coefficient parameters for zero count of variable of interest \eqn{ \gamma_{0}, \gamma_{1}, and \gamma_{2}}{\gamma0, \gamma1, \gamma2} are set with values = 0,5.
#'     \cr Set the dispersion parameter \eqn{\alpha}{\alpha} with a certain value, we set \eqn{ \alpha = 1}.
#'     \cr Calculate the probability of hurdle crossing \eqn{\pi}{\pi} = \eqn{exp(\gamma_{0} + x_{1}\gamma_{1} + x_{2}\gamma_{2})}{exp(\gamma0 + x1\gamma1 + x2\gamma2)} / \eqn{1+exp(\gamma_{0} + x_{1}\gamma_{1} + x_{2}\gamma_{2})}{1+exp(\gamma0 + x1\gamma1+ x2\gamma2)}
#'     \cr Calculate \eqn{\mu}{\mu} = \eqn{exp(\beta_{0} + x_{1}\beta_{1} + x_{2}\beta_{2} + u)}{exp(\beta0 + x1\beta1 + x2\beta2 + u)}
#'     \cr Generate direct estimate \code{y ~ Hurdle Negative Binomial}, with the following parameters : \eqn{\mu}{\mu}, \eqn{\alpha}{\alpha}, \eqn{\pi}{\pi}
#'     \cr Calculate the variance of \code{y}. Variance of \code{y} is obtained using MGF Method.
#'     \item Auxiliary variables x1, x2, direct estimation (y) and variance (vardir) are combined in a dataframe called dataHNB.
#' }
#'
#' @usage data(dataHNB)
#'
#' @format A data frame with 50 rows and 2 variables:
#' \describe{
#'   \item{y}{Direct Estimation of y}
#'   \item{x1}{Auxiliary variable of x1}
#'   \item{x2}{Auxiliary variable of x2}
#'   \item{vardir}{Sampling Variance of y}
#' }
#'
"dataHNB"
