% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SABARSI.R
\name{merge_signals}
\alias{merge_signals}
\title{Obtain the set of signature signals
Merge groups of concatenated signals and give the time indices of signature signals.}
\usage{
merge_signals(xr, object, t.tol = 4, cor.tol = 0.5)
}
\arguments{
\item{xr}{A p-length vector that represents a background-removed spectrum with p frequency channels.}

\item{object}{An object obtained from \code{signal_detection}}

\item{t.tol}{A positive integer, which is the tolerance of time difference when comparing two signals.}

\item{cor.tol}{A number between 0 and 1. Two signals is considered to be similar enough if their correlation is higher than \code{cor.tol}.}
}
\value{
A vector recording the time indices of signature signals.
}
\description{
Obtain the set of signature signals
Merge groups of concatenated signals and give the time indices of signature signals.
}
\examples{
\donttest{
## xr is the matrix of background removed spectra.
res <- signal_detection(xr) ## detect the signals in xr
tim.index.ss <- merge_signals(xr = xr, object = res)  ## the set of signature signals.
}
}
