% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linMod.R
\name{linMod}
\alias{linMod}
\alias{linMod0}
\alias{linModB}
\alias{linModB0}
\alias{linModA}
\alias{linModA0}
\alias{linModD}
\alias{linModD0}
\alias{linModM}
\alias{linModM0}
\title{Linear model to replace in rxode2 ui model}
\usage{
linMod(
  variable,
  power,
  dv = "dv",
  intercept = TRUE,
  type = c("replace", "before", "after"),
  num = NULL,
  iniDf = NULL,
  data = FALSE,
  mv = FALSE
)

linMod0(..., intercept = FALSE)

linModB(..., type = "before")

linModB0(..., intercept = FALSE, type = "before")

linModA(..., type = "after")

linModA0(..., intercept = FALSE, type = "after")

linModD(..., intercept = TRUE, data = TRUE)

linModD0(..., intercept = FALSE, data = TRUE)

linModM(..., intercept = TRUE, mv = TRUE)

linModM0(..., intercept = FALSE, mv = TRUE)
}
\arguments{
\item{variable}{The variable that the rxode2 will be made on.}

\item{power}{The power of the polynomial that will be generated.}

\item{dv}{the dependent variable to use to generate the initial
estimates from the data. If \code{NULL} query using \code{rxUdfUiData()}.}

\item{intercept}{Boolean that tells if the intercept be generated.}

\item{type}{the type of linear model replacement to be used.}

\item{num}{the number the particular model is being generated. If
unspecified, query using \code{rxUdfUiNum()}.}

\item{iniDf}{the initialization \code{data.frame}, if \code{NULL} query using
\code{rxUdfUiIniDf()}}

\item{data}{logical that tells if the initial estimates of the
linear model should be estimated from the data.}

\item{mv}{logical that tell if the model variables need to be used
to generate model variables.}

\item{...}{arguments that are passed to \code{linMod()} for the other
abbreviations of \code{linMod()}}
}
\value{
a list for use in when generating the \code{rxode2} ui model see
\code{rxUdfUi()} for details.
}
\description{
Linear model to replace in rxode2 ui model
}
\section{Functions}{
\itemize{
\item \code{linMod0()}: linear model without intercept

\item \code{linModB()}: linear model before where it occurs

\item \code{linModB0()}: linear model before where the user function occurs

\item \code{linModA()}: linear model after where the user function occurs

\item \code{linModA0()}: liner model without an intercept placed after where the user function occurs

\item \code{linModD()}: linear model where initial estimates are generated from the data

\item \code{linModD0()}: linear model where initial estimates are generated from the data (no intercept)

\item \code{linModM()}: linear model where the model variables are used to generate the model variables

\item \code{linModM0()}: linear model where the model variables are used to generate the model variables (no intercept)

}}
\examples{

linMod(x, 3)
}
\seealso{
Other User functions: 
\code{\link{rxUdfUiData}()},
\code{\link{rxUdfUiEst}()},
\code{\link{rxUdfUiIniLhs}()},
\code{\link{rxUdfUiMv}()},
\code{\link{rxUdfUiNum}()},
\code{\link{rxUdfUiParsing}()}
}
\author{
Matthew L. Fidler
}
\concept{User functions}
