% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikNbinom}
\alias{llikNbinom}
\title{Calculate the log likelihood of the negative binomial function (and its derivatives)}
\usage{
llikNbinom(x, size, prob, full = FALSE)
}
\arguments{
\item{x}{Number of successes}

\item{size}{Size of trial}

\item{prob}{probability of success}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the pdf value of with
\code{dProb} that has the derivatives with respect to the parameters at
the observation time-point
}
\description{
Calculate the log likelihood of the negative binomial function (and its derivatives)
}
\details{
In an \code{rxode2()} model, you can use \code{llikNbinom()} but you have to
use all arguments.  You can also get the derivative of \code{prob} with
\code{llikNbinomDprob()}
}
\examples{
\donttest{
llikNbinom(46:54, 100, 0.5)

llikNbinom(46:54, 100, 0.5, TRUE)

# In rxode2 you can use:

et <- et(46:54)
et$size <- 100
et$prob <-0.5

model <- rxode2({
  fx <- llikNbinom(time, size, prob)
  dProb <- llikNbinomDprob(time, size, prob)
})

rxSolve(model, et)
}
}
\author{
Matthew L. Fidler
}
