% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internals.R
\name{dst_POSIXct}
\alias{dst_POSIXct}
\title{Return POSIXct time from 7 variables.}
\usage{
dst_POSIXct(y, m, d, hr, mn, sec, tz)
}
\arguments{
\item{y}{vector of years}

\item{m}{vector of months}

\item{d}{vector of days}

\item{hr}{vector of hours}

\item{mn}{vector of minutes}

\item{sec}{vector of seconds}

\item{tz}{vector of timezones}
}
\value{
POSIXct time assuming vectors sorted by true chronological order,
   at least for the hour that "occurs twice", once with Daylight Time, 
   then again with Standard Time.  If there are no nonmonotonicities in 
   the times, all times in this hour will be assumed to be Daylight Time.
}
\description{
In locations with a Daylight Saving/Standard
   time change that occurs twice annually, the year has one 23 hour day 
   and one 25 hour day, if by day we mean "an ordered set of all instants
   in time which are assigned the same date".  In the US/Los_Angeles 
   timezone, there is one day in the spring where are no valid times 
   between the moment before 02:00:00 and 03:00:00.  Similarly, there
   is one day in the fall where there are two instants described by all
   times between 01:00:00 and 01:59:59, first as a set of PDT times, then
   as a set of PST times. \code{as.POSIXct()} doesn't handle this case well.
   Times inside this region are assigned to DST until the sequence of
   clock times has a time which is the same or earlier than its predecessor,
   and all subsequent ambiguous times are assigned to Standard Time.
}
