% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_template.R
\name{estimate_template}
\alias{estimate_template}
\title{Estimate the Template Spectrum}
\usage{
estimate_template(
  SPECTRA,
  min_wvl = NULL,
  max_wvl = NULL,
  bandwidth_bnds = c(0.017, 0.05),
  min_count = 100,
  cores = 19
)
}
\arguments{
\item{SPECTRA}{a list of all observed spectra to use in estimating the template.
Each observed spectrum should have the format of being a list with the following
names (or a dataframe with the following columns): ``Wavelength" and ``Flux".}

\item{min_wvl}{a number that indicates the minimum wavelength for the estimated
template}

\item{max_wvl}{a number that indicates the maximum wavelength for the estimated
template}

\item{bandwidth_bnds}{a vector of length 2 that gives the interval of bandwidth
values (in the same units as the wavelength of the spectra) to be considered in
the generalized cross-validation}

\item{min_count}{the minimum number of data points required for local regression
to be done on a given wavelength chunk}

\item{cores}{the number of cores to parallelize over (if set to 1, no
parallelizing is done)}
}
\value{
a list with the following elements:
\item{Wavelength}{the wavelength axis of the estimated template}
\item{Flux}{the normalized flux of the estimated template}
\item{Chunk_bounds}{a list of length 2 vectors that give
the wavelength bounds for each chunk for which the smoothing was done on}
\item{Bandwidths}{the bandwidths chosen for each of the chunks}
\item{Std_err}{the standard errors of the estimated normalized flux that can
be used for prediction confidence intervals}
}
\description{
This function uses local quadratic regression to estimate the template
spectrum from a collection of observed spectra from a star as described in
\href{https://arxiv.org/abs/2005.14083}{Holzer et al. (2020)}. All observed
spectra are assumed to be normalized. The bandwidth is chosen locally through
generalized cross-validation. We \strong{strongly} recommend using parallel
computing for this function. Therefore, the \code{cores} argument has the
default value of 19.
}
\examples{
data(spectra)
plot(spectra[[1]]$Wavelength, spectra[[1]]$Flux, col='gray', type='l')
for(spec in spectra){
 lines(spec$Wavelength, spec$Flux, col='gray')
}
tempest = estimate_template(spectra, cores = 1)
lines(tempest$Wavelength, tempest$Flux, col='red')
}
