% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/table.R
\name{html_table}
\alias{html_table}
\title{Parse an html table into a data frame.}
\usage{
html_table(x, header = NA, trim = TRUE, fill = FALSE, dec = ".")
}
\arguments{
\item{x}{A node, node set or document.}

\item{header}{Use first row as header? If \code{NA}, will use first row
if it consists of \code{<th>} tags.}

\item{trim}{Remove leading and trailing whitespace within each cell?}

\item{fill}{If \code{TRUE}, automatically fill rows with fewer than
the maximum number of columns with \code{NA}s.}

\item{dec}{The character used as decimal mark.}
}
\description{
Parse an html table into a data frame.
}
\section{Assumptions}{


\code{html_table} currently makes a few assumptions:

\itemize{
\item No cells span multiple rows
\item Headers are in the first row
}
}
\examples{
tdist <- read_html("http://en.wikipedia.org/wiki/Student\%27s_t-distribution")
tdist \%>\%
  html_node("table.infobox") \%>\%
  html_table(header = FALSE)

births <- read_html("http://www.ssa.gov/oact/babynames/numberUSbirths.html")
html_table(html_nodes(births, "table")[[2]])

# If the table is badly formed, and has different number of rows in
# each column use fill = TRUE. Here's it's due to incorrect colspan
# specification.
skiing <- read_html("http://data.fis-ski.com/dynamic/results.html?sector=CC&raceid=22395")
skiing \%>\%
  html_table(fill = TRUE)
}

