% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvmultinom.R
\name{rvmultinom}
\alias{rvmultinom}
\title{Generate Random Variables from a Multinomial Sampling Model}
\usage{
rvmultinom(n = 1, size = 1, prob)
}
\arguments{
\item{n}{integer, number of random variables to generate}

\item{size}{integer or integer-valued rv: the number of trials (size of each
sample)}

\item{prob}{vector (of length at least 3) prior probabilities of successes
of each trial (may be constant or an rv object)}
}
\value{
A random array of dimensions \code{length(prob)} times \code{n}.
}
\description{
Generates a random vector from a multinomial sampling model.
}
\details{
The length of \code{prob} determines the number of bins.

The vector \code{prob} will be normalized to have sum 1.

If \code{length(prob)} is two, \code{rvbinom} is called instead.

NOTE. Case of random \code{n} or \code{size} or \code{prob} --- not yet
optimized for speed.
}
\examples{

  y <- rvmultinom(n=3, size=1, prob=c(0.20, 0.30, 0.50))

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
