% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{exp_almon}
\alias{exp_almon}
\title{Exponential Almon Lag}
\usage{
exp_almon(k, K, w1, w2)
}
\arguments{
\item{k}{Lag of interest.}

\item{K}{Number of (lagged) realizations to consider.}

\item{w1, w2}{Parameters governing the weights of each \eqn{k} lag.}
}
\value{
The weights associated to each lag \eqn{k}, with \eqn{k=1,\cdots,K}.
}
\description{
Represents a tool able to accommodate various lag structures for the
additional MIDAS variable observed each "low-frequency" period \eqn{t}. It can have a monotonically increasing,
decreasing weighting scheme or a hump-shaped weighting scheme. As in \insertCite{ghysels_2007;textual}{rumidas},
here the function form uses only two parameters:
\deqn{\delta_k(\omega_1, \omega_2) = \frac{exp(\omega_{1}k + \omega_2 k^2)}{\sum_{k=1}^K exp(\omega_1 k + \omega_2 k^2)}.}
For additional details, see \insertCite{almon_1965;textual}{rumidas} and \insertCite{ghysels_2007;textual}{rumidas}.
}
\examples{
# suppose to have four lags: 
# K<-4 # Note: the number of lags to consider
# w1<-1	
# w2<- -0.5 # by setting w2<0, the monotonically decreasing weighting scheme is used
exp_almon(1:4,K=4,w1=0.1,w2=-0.5)
}
\references{
\insertAllCited{}
}
