% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubias.R
\docType{package}
\name{rubias}
\alias{rubias}
\alias{rubias-package}
\title{rubias: Bayesian inference from the conditional genetic stock identification model}
\description{
Read the "rubias-overview" vignette for information on data input formats
and how to use the package
}
\section{the \code{rubias} main high-level functions}{


The following functions are wrappers, designed for user-friendly input and useful output:

\code{\link{infer_mixture}} is used to perform genetic stock identification.
Options include standard MCMC and the parametric bootstrap bias correction.

\code{\link{self_assign}} does simple self-assignment of individuals in a reference data set
to the various collections in the reference data set.

\code{\link{assess_reference_loo}} does leave-one-out based simulations to predict how
accurately GSI can be done.

\code{\link{assess_reference_mc}} uses Monte-Carlo cross-validation based simulations
to predict how accurately GSI can be done.

\code{\link{assess_pb_bias_correction}} attempts to demonstrate how much (or little)
improvement can be expected from the parametric bootstrap correction given a particular
reference data set.
}

\section{genetic data format}{


See the vignette.
}

\section{example data}{


\code{\link{alewife}}, \code{\link{blueback}}, and \code{\link{chinook}} are
genetic data sets that are useful for playing around with rubias and testing it
out.
}

