% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_limit.R
\name{rate_limit}
\alias{rate_limit}
\alias{rate_limits}
\title{Get rate limit data for given Twitter access tokens.}
\usage{
rate_limit(token = NULL, query = NULL, parse = TRUE)

rate_limits(token = NULL, query = NULL, parse = TRUE)
}
\arguments{
\item{token}{One or more OAuth tokens. By default token = NULL
fetches a non-exhausted token from an environment variable. Find
instructions on how to create tokens and setup an environment
variable in the tokens vignette (in r, send \code{?tokens} to
console).}

\item{query}{Specific API (path) or a character function name,
e.g., query = "get_timelines", used to subset the returned data.
If null, this function returns entire rate limit request object
as a tibble data frame. Otherwise, query returns specific values
matching the query of interest; e.g., query = "lookup/users"
returns remaining limit for user lookup requests; type =
"followers/ids" returns remaining limit for follower id requests;
type = "friends/ids" returns remaining limit for friend id
requests.}

\item{parse}{Logical indicating whether to parse response object
into a data frame.}
}
\value{
Tibble data frame with rate limit information pertaining to
  the limit (max allowed), remaining (specific to token), reset
  (minutes until reset), and reset_at (time of rate limit
  reset). If query is specified, only relevant rows are returned.
}
\description{
Returns rate limit information for one or more Twitter tokens,
optionally filtered by rtweet function or specific Twitter API
path(s)
}
\details{
If multiple tokens are provided, this function will return
  the names of the associated [token] applications as new variable
  (column) or as a named element (if parse = FALSE).
}
\examples{

\dontrun{

## get all rate_limit information for default token
rate_limit()

## get rate limit info for API used in lookup_statuses
rate_limit("lookup_statuses")

## get rate limit info for specific token
token <- get_tokens()
rate_limit(token)
rate_limit(token, "search_tweets")

}

}
\seealso{
\url{https://developer.twitter.com/en/docs/developer-utilities/rate-limit-status/api-reference/get-application-rate_limit_status}

Other tokens: \code{\link{create_token}},
  \code{\link{get_tokens}}
}
\concept{tokens}
