% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mentions.R
\name{get_mentions}
\alias{get_mentions}
\title{Get mentions for the authenticating user.}
\usage{
get_mentions(n = 200, since_id = NULL, max_id = NULL, parse = TRUE,
  token = NULL, ...)
}
\arguments{
\item{n}{Specifies the number of Tweets to try and retrieve, up to
a maximum of 200 (the default). The value of count is best
thought of as a limit to the number of tweets to return because
suspended or deleted content is removed after the count has been
applied.}

\item{since_id}{Returns results with an ID greater than (that is,
more recent than) the specified ID. There are limits to the
number of Tweets which can be accessed through the API. If the
limit of Tweets has occurred since the since_id, the since_id
will be forced to the oldest ID available.}

\item{max_id}{Returns results with an ID less than (that is, older
than) or equal to the specified ID.}

\item{parse}{Logical indicating whether to convert the response
object into an R list. Defaults to TRUE.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find
instructions on how to create tokens and setup an environment
variable in the tokens vignette (in r, send \code{?tokens} to
console).}

\item{...}{Other arguments passed as parameters in composed API
query.}
}
\value{
Tibble of mentions data.
}
\description{
Returns data on up to 200 of the most recent mentions (Tweets
containing a users's screen_name) of the authenticating user.
}
\details{
The timeline returned is the equivalent of the one seen
  when you view your mentions on twitter.com. This method can only
  return up to 800 tweets.
}
\examples{

\dontrun{

## get most recent 200 mentions of authenticating user
mymentions <- get_mentions()

## view data
mymentions

}

}
\seealso{
\url{https://developer.twitter.com/en/docs/tweets/timelines/api-reference/get-statuses-mentions_timeline}

Other tweets: \code{\link{get_favorites}},
  \code{\link{get_timeline}}, \code{\link{lists_statuses}},
  \code{\link{lookup_statuses}},
  \code{\link{search_tweets}}, \code{\link{tweets_data}},
  \code{\link{tweets_with_users}}
}
