% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_workhorse.R
\name{trim_workhorse}
\alias{trim_workhorse}
\title{TRIM workhorse function}
\usage{
trim_workhorse(count, site.id, time.id, covars = data.frame(), model = 2,
  serialcor = FALSE, overdisp = FALSE, changepoints = integer(0),
  weights = numeric(0), covin = list(), conv_crit = 1e-05,
  max_iter = 200, max_sub_step = 7, soft = FALSE, debug = FALSE)
}
\arguments{
\item{count}{a numerical vector of count data.}

\item{site.id}{a numerical vector time points for each count data point.}

\item{time.id}{an numerical vector time points for each count data point.}

\item{covars}{an optional data frame with covariates}

\item{model}{a model type selector}

\item{serialcor}{a flag indication of autocorrelation has to be taken into account.}

\item{overdisp}{a flag indicating of overdispersion has to be taken into account.}

\item{changepoints}{a numerical vector change points (only for Model 2)}

\item{weights}{a numerical vector of weights.}

\item{covin}{...}

\item{conv_crit}{convergence criterion.}

\item{max_iter}{maximum number of iterations allowed.}

\item{soft:}{specifies if trim on error returns an error code (TRUE) or just stops with a message (FALSE)}
}
\value{
a list of class \code{trim}, that contains all output, statistiscs, etc.
  Usually this information is retrieved by a set of postprocessing functions
}
\description{
TRIM workhorse function
}
\keyword{internal}

