% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcrANOVA.r
\name{qpcrANOVA}
\alias{qpcrANOVA}
\title{ANOVA of RE values based on CRD}
\usage{
qpcrANOVA(
  x,
  numberOfrefGenes,
  block = NULL,
  p.adj = c("none", "holm", "hommel", "hochberg", "bonferroni", "BH", "BY", "fdr")
)
}
\arguments{
\item{x}{A data frame consisting of condition columns, target gene efficiency (E), target Gene Ct, reference gene efficiency and reference gene Ct values, respectively. Each Ct in the data frame is the mean of technical replicates. Complete amplification efficiencies of 2 was assumed in the example data for all wells but the calculated efficienies can be used instead.}

\item{numberOfrefGenes}{number of reference genes (1 or 2). Up to two reference genes can be handled.}

\item{block}{column name of the blocking factor (for correct column arrangement see example data.). When a qPCR experiment is done in multiple qPCR plates, variation resulting from the plates may interfere with the actual amount of gene expression. One solution is to conduct each plate as a complete randomized block so that at least one replicate of each treatment and control is present on a plate. Block effect is usually considered as random and its interaction with any main effect is not considered.}

\item{p.adj}{Method for adjusting p values (see p.adjust)}
}
\value{
A list with 5 elements:
\describe{
  \item{Final_data}{The row data plus weighed delta Ct (wDCt) values.}
  \item{lm}{The output of linear model analysis including ANOVA tables based on factorial experiment and completely randomized design (CRD).}
  \item{ANOVA_factorial}{ANOVA table based on factorial arrangement}
  \item{ANOVA_CRD}{ANOVA table based on CRD}
  \item{Result}{The result table including treatments and factors, RE (Relative Expression), LCL, UCL, letter grouping and standard deviation of relative expression.}
  \item{Post_hoc_Test}{Post hoc test of FC (Fold Change), pvalue, significance and confidence interval (LCL, UCL).}
}
}
\description{
Analysis of Variance of relative efficiency (RE) values based on a completely randomized design (CRD). Even there are more than a factor in the experiment, it is still possible to apply CRD analysis on the factor-level combinations as treatments. Analysis of variance based on factorial design or analysis of covariance can be performed using \code{qpcrANCOVA} function.
}
\details{
The \code{qpcrANOVA} function performs analysis of variance (ANOVA) of relative efficiency (RE) values based on a completely randomized design (CRD). 
It is suitable when relative expression (RE) analysis between different treatment combinations 
(in a Uni- or multi-factorial experiment) is desired. If there are more than a factor in the experiment, 
it is still possible to apply CRD analysis on the factor-level combinations as treatments. 
For this, a column of treatment combinations is made first as a grouping factor Fold change analysis based 
on factorial design or analysis of covariance for the can be performed using \link{qpcrANCOVA}.
}
\examples{

# If the data include technical replicates, means of technical replicates
# should be calculated first using meanTech function.

# Applying ANOVA analysis
qpcrANOVA(
     data_3factor_a,
     numberOfrefGenes = 1,
     p.adj = "none")


qpcrANOVA(
    data_2factorBlock,
    block = "Block",
    numberOfrefGenes = 1)


}
\references{
Livak, Kenneth J, and Thomas D Schmittgen. 2001. Analysis of
Relative Gene Expression Data Using Real-Time Quantitative PCR and the
Double Delta CT Method. Methods 25 (4). doi:10.1006/meth.2001.1262.

Ganger, MT, Dietz GD, and Ewing SJ. 2017. A common base method for analysis of qPCR data
and the application of simple blocking in qPCR experiments. BMC bioinformatics 18, 1-11.

Yuan, Joshua S, Ann Reed, Feng Chen, and Neal Stewart. 2006.
Statistical Analysis of Real-Time PCR Data. BMC Bioinformatics 7 (85). doi:10.1186/1471-2105-7-85.
}
\author{
Ghader Mirzaghaderi
}
