% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mih.R
\name{mih}
\alias{mih}
\title{Mean income per household}
\usage{
mih(dataset, hhcsw = "DB090", ehhs = "HX050", edi = "HX090", ci = NULL,
  rep = 1000, verbose = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing the variables.}

\item{hhcsw}{a character string indicating the variable name of the household cross-sectional weight. Default is "DB090".}

\item{ehhs}{a character string indicating the variable name of the equivalised household size. Default is "HX050".}

\item{edi}{a character string indicating the variable name of the equivalised disposable income (with the modified OECD scale). Default is "HX090".}

\item{ci}{a scalar or vector containing the confidence level(s) of the required interval(s). Default does not calculate the confidence interval.}

\item{rep}{a number to make the confidence interval using boostrap technique.}

\item{verbose}{logical; if TRUE the confidence interval is plotted.}
}
\value{
The value of mean income per household.
}
\description{
Estimates the mean income per household.
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT")
mih(ATdataset)

}
\references{
B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.

\url{http://ec.europa.eu/eurostat/statistics-explained/index.php/Glossary:Equivalised_disposable_income}
}
\seealso{
setupDataset.
}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
