% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_memberappear.R
\name{cg_memberappear}
\alias{cg_memberappear}
\title{Get information about a particular member's appearances on the House or
Senate floor.}
\usage{
cg_memberappear(memberid = NULL, key = NULL, ...)
}
\arguments{
\item{memberid}{The member's unique ID number (alphanumeric). To find a
member's ID number, get the list of members for the appropriate House
or Senate. You can also use the Biographical Directory of the United
States Congress to get a member's ID. In search results, each member's
name is linked to a record by index ID (e.g.,
http://bioguide.congress.gov/scripts/biodisplay.pl?index=C001041).
Use the index ID as member-id in your request.}

\item{key}{(character) your Propublica API key; pass in, or loads from .Renviron
as \code{PROPUBLICA_API_KEY}. See \code{\link{rtimes-package}} for info on rate limits.}

\item{...}{Curl options (debugging tools mostly) passed to \code{\link[httr]{GET}}}
}
\value{
Get information about a particular member's appearances on the
   House or Senate floor.
}
\description{
Get information about a particular member's appearances on the House or
Senate floor.
}
\examples{
\dontrun{
cg_memberappear(memberid='S001181')
}
}
