% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg_channel_subscribers.R
\name{tg_channel_subscribers}
\alias{tg_channel_subscribers}
\title{Get channel subscribers nunmber by day}
\usage{
tg_channel_subscribers(
  channel_id = tg_get_channel_id(),
  start_date = Sys.Date() - 15,
  end_date = Sys.Date(),
  group = c("day", "hour", "week", "month")
)
}
\arguments{
\item{channel_id}{Channel ID (@username, t.me/username, t.me/joinchat/AAAAABbbbbcccc ... or channel ID in 'TGStat')}

\item{start_date}{Start date of report period}

\item{end_date}{End date of report period}

\item{group}{Time group: hour, day, week, month}
}
\value{
tibble with subscribers stat
}
\description{
The method allows you to get the number of channel subscribers in dynamics by hours, days, weeks, months.
}
\details{
For grouping group = day, the number of subscribers as of the end of the day will be returned.

For groupings group = week and group = month, the number of subscribers at the end of the last day of the period (week or month) will be returned.

Depending on the requested grouping type group - the period field will take one of the following formats:
\itemize{
\item hour: Y-m-d H:00
\item day: Y-m-d
\item week: Y-W
\item month: Y-m
}
}
\examples{
\dontrun{
channel_subscribers <- tg_channel_subscribers(
    channel_id = "R4marketing",
    start_date = "2021-06-01",
    end_date = "2021-10-31",
    group = "month"
 )
}
}
\references{
See also \href{https://api.tgstat.ru/docs/ru/channels/subscribers.html}{TGStat API Documentation of metrod channels/subscribers}
}
